
unit Androidapi.JNI.Stream;

interface

uses
  Androidapi.JNIBridge,
  Androidapi.JNI.JavaTypes;

type
// ===== Forward declarations =====

  JObjectInputStream = interface;//java.io.ObjectInputStream
  JObjectInputStream_GetField = interface;//java.io.ObjectInputStream$GetField
  JObjectInputValidation = interface;//java.io.ObjectInputValidation
  JObjectOutput = interface;//java.io.ObjectOutput
  JObjectOutputStream = interface;//java.io.ObjectOutputStream
  JObjectOutputStream_PutField = interface;//java.io.ObjectOutputStream$PutField
  Jio_ObjectStreamClass = interface;//java.io.ObjectStreamClass
  JObjectStreamField = interface;//java.io.ObjectStreamField
  JAbstractStringBuilder = interface;//java.lang.AbstractStringBuilder
  JStringBuffer = interface;//java.lang.StringBuffer
  JStringBuilder = interface;//java.lang.StringBuilder

// ===== Interface declarations =====

  JObjectInputStreamClass = interface(JInputStreamClass)
    ['{443A1BEF-E21F-4012-A28B-4D7735136BD3}']
    {class} function init(input: JInputStream): JObjectInputStream; cdecl;//Deprecated
    {class} procedure defaultReadObject; cdecl;//Deprecated
    {class} function read: Integer; cdecl; overload;//Deprecated
    {class} function read(buffer: TJavaArray<Byte>; byteOffset: Integer; byteCount: Integer): Integer; cdecl; overload;//Deprecated
    {class} function readDouble: Double; cdecl;
    {class} function readFields: JObjectInputStream_GetField; cdecl;
    {class} function readFloat: Single; cdecl;
    {class} function readLine: JString; cdecl;//Deprecated
    {class} function readLong: Int64; cdecl;
    {class} function readObject: JObject; cdecl;
    {class} function readUnshared: JObject; cdecl;
    {class} function readUnsignedByte: Integer; cdecl;
    {class} function readUnsignedShort: Integer; cdecl;
  end;

  [JavaSignature('java/io/ObjectInputStream')]
  JObjectInputStream = interface(JInputStream)
    ['{C1360ABB-AF58-4607-B43E-C1E1652E8FC2}']
    function available: Integer; cdecl;//Deprecated
    procedure close; cdecl;//Deprecated
    function readBoolean: Boolean; cdecl;
    function readByte: Byte; cdecl;
    function readChar: Char; cdecl;
    procedure readFully(dst: TJavaArray<Byte>); cdecl; overload;
    procedure readFully(dst: TJavaArray<Byte>; offset: Integer; byteCount: Integer); cdecl; overload;
    function readInt: Integer; cdecl;
    function readShort: SmallInt; cdecl;
    function readUTF: JString; cdecl;
    procedure registerValidation(object_: JObjectInputValidation; priority: Integer); cdecl;
    function skipBytes(length: Integer): Integer; cdecl;
  end;
  TJObjectInputStream = class(TJavaGenericImport<JObjectInputStreamClass, JObjectInputStream>) end;

  JObjectInputStream_GetFieldClass = interface(JObjectClass)
    ['{B2A17356-DC2C-4DD0-BA5B-926AB526F0F6}']
    {class} function init: JObjectInputStream_GetField; cdecl;//Deprecated
    {class} function &get(name: JString; defaultValue: Boolean): Boolean; cdecl; overload;
    {class} function &get(name: JString; defaultValue: Char): Char; cdecl; overload;
    {class} function &get(name: JString; defaultValue: Byte): Byte; cdecl; overload;
    {class} function &get(name: JString; defaultValue: Int64): Int64; cdecl; overload;
    {class} function &get(name: JString; defaultValue: Single): Single; cdecl; overload;
    {class} function &get(name: JString; defaultValue: Double): Double; cdecl; overload;
  end;

  [JavaSignature('java/io/ObjectInputStream$GetField')]
  JObjectInputStream_GetField = interface(JObject)
    ['{B087619B-FB6D-415B-BE57-9D4EBDC7E9B9}']
    function defaulted(name: JString): Boolean; cdecl;
    function &get(name: JString; defaultValue: SmallInt): SmallInt; cdecl; overload;
    function &get(name: JString; defaultValue: Integer): Integer; cdecl; overload;
    function &get(name: JString; defaultValue: JObject): JObject; cdecl; overload;
    function getObjectStreamClass: Jio_ObjectStreamClass; cdecl;
  end;
  TJObjectInputStream_GetField = class(TJavaGenericImport<JObjectInputStream_GetFieldClass, JObjectInputStream_GetField>) end;

  JObjectInputValidationClass = interface(IJavaClass)
    ['{62ED8408-3F77-4D14-869F-9B23C6114A7E}']
  end;

  [JavaSignature('java/io/ObjectInputValidation')]
  JObjectInputValidation = interface(IJavaInstance)
    ['{84E8CFA7-F64F-43D1-AC79-DAE8ADB43A56}']
    procedure validateObject; cdecl;
  end;
  TJObjectInputValidation = class(TJavaGenericImport<JObjectInputValidationClass, JObjectInputValidation>) end;

  JObjectOutputClass = interface(JAutoCloseableClass)
    ['{F4A98D44-0FB7-4173-B4CF-B078F3B70FD9}']
    {class} procedure close; cdecl;
    {class} procedure flush; cdecl;
    {class} procedure writeObject(obj: JObject); cdecl;
  end;

  [JavaSignature('java/io/ObjectOutput')]
  JObjectOutput = interface(JAutoCloseable)
    ['{6161B3E5-4157-483D-A2E5-BBD585E248FB}']
    procedure write(buffer: TJavaArray<Byte>); cdecl; overload;
    procedure write(buffer: TJavaArray<Byte>; offset: Integer; count: Integer); cdecl; overload;
    procedure write(value: Integer); cdecl; overload;
  end;
  TJObjectOutput = class(TJavaGenericImport<JObjectOutputClass, JObjectOutput>) end;

  JObjectOutputStreamClass = interface(JOutputStreamClass)
    ['{D43CF30C-1E94-4D2E-A473-91EE54E41F07}']
    {class} function init(output: JOutputStream): JObjectOutputStream; cdecl;//Deprecated
    {class} procedure defaultWriteObject; cdecl;//Deprecated
    {class} procedure flush; cdecl;//Deprecated
    {class} function putFields: JObjectOutputStream_PutField; cdecl;//Deprecated
    {class} procedure write(value: Integer); cdecl; overload;//Deprecated
    {class} procedure writeBoolean(value: Boolean); cdecl;//Deprecated
    {class} procedure writeByte(value: Integer); cdecl;//Deprecated
    {class} procedure writeDouble(value: Double); cdecl;//Deprecated
    {class} procedure writeFields; cdecl;//Deprecated
    {class} procedure writeFloat(value: Single); cdecl;//Deprecated
    {class} procedure writeShort(value: Integer); cdecl;
    {class} procedure writeUTF(value: JString); cdecl;
    {class} procedure writeUnshared(object_: JObject); cdecl;
  end;

  [JavaSignature('java/io/ObjectOutputStream')]
  JObjectOutputStream = interface(JOutputStream)
    ['{F4E441F8-B3D0-4463-A052-880F6644FB42}']
    procedure close; cdecl;//Deprecated
    procedure reset; cdecl;//Deprecated
    procedure useProtocolVersion(version: Integer); cdecl;//Deprecated
    procedure write(buffer: TJavaArray<Byte>; offset: Integer; length: Integer); cdecl; overload;//Deprecated
    procedure writeBytes(value: JString); cdecl;//Deprecated
    procedure writeChar(value: Integer); cdecl;//Deprecated
    procedure writeChars(value: JString); cdecl;//Deprecated
    procedure writeInt(value: Integer); cdecl;
    procedure writeLong(value: Int64); cdecl;
    procedure writeObject(object_: JObject); cdecl;
  end;
  TJObjectOutputStream = class(TJavaGenericImport<JObjectOutputStreamClass, JObjectOutputStream>) end;

  JObjectOutputStream_PutFieldClass = interface(JObjectClass)
    ['{C280794E-D22D-40E4-854E-442CAC3B5350}']
    {class} function init: JObjectOutputStream_PutField; cdecl;//Deprecated
    {class} procedure put(name: JString; value: Boolean); cdecl; overload;
    {class} procedure put(name: JString; value: Byte); cdecl; overload;
    {class} procedure put(name: JString; value: Int64); cdecl; overload;
    {class} procedure put(name: JString; value: Single); cdecl; overload;
    {class} procedure put(name: JString; value: Double); cdecl; overload;
  end;

  [JavaSignature('java/io/ObjectOutputStream$PutField')]
  JObjectOutputStream_PutField = interface(JObject)
    ['{0312E88F-1456-44D3-820F-C162F2F9CCAF}']
    procedure put(name: JString; value: Char); cdecl; overload;
    procedure put(name: JString; value: SmallInt); cdecl; overload;
    procedure put(name: JString; value: Integer); cdecl; overload;
    procedure put(name: JString; value: JObject); cdecl; overload;
    procedure write(out_: JObjectOutput); cdecl;//Deprecated
  end;
  TJObjectOutputStream_PutField = class(TJavaGenericImport<JObjectOutputStream_PutFieldClass, JObjectOutputStream_PutField>) end;

  Jio_ObjectStreamClassClass = interface(JObjectClass)
    ['{58DBAE53-DDE4-43B3-8112-035D4955F07D}']
    {class} function _GetNO_FIELDS: TJavaObjectArray<JObjectStreamField>; cdecl;
    {class} function getName: JString; cdecl;//Deprecated
    {class} function getSerialVersionUID: Int64; cdecl;//Deprecated
    {class} function lookup(cl: Jlang_Class): Jio_ObjectStreamClass; cdecl;//Deprecated
    {class} function lookupAny(cl: Jlang_Class): Jio_ObjectStreamClass; cdecl;//Deprecated
    {class} property NO_FIELDS: TJavaObjectArray<JObjectStreamField> read _GetNO_FIELDS;
  end;

  [JavaSignature('java/io/ObjectStreamClass')]
  Jio_ObjectStreamClass = interface(JObject)
    ['{13F49D75-C16F-47C6-91F9-B37C879D7FF2}']
    function forClass: Jlang_Class; cdecl;//Deprecated
    function getField(name: JString): JObjectStreamField; cdecl;//Deprecated
    function getFields: TJavaObjectArray<JObjectStreamField>; cdecl;//Deprecated
    function toString: JString; cdecl;//Deprecated
  end;
  TJio_ObjectStreamClass = class(TJavaGenericImport<Jio_ObjectStreamClassClass, Jio_ObjectStreamClass>) end;

  JObjectStreamFieldClass = interface(JObjectClass)
    ['{FE2D8AF0-961B-40C3-834D-38B8B5258EDA}']
    {class} function init(name: JString; cl: Jlang_Class): JObjectStreamField; cdecl; overload;//Deprecated
    {class} function init(name: JString; cl: Jlang_Class; unshared: Boolean): JObjectStreamField; cdecl; overload;//Deprecated
    {class} function compareTo(o: JObject): Integer; cdecl;//Deprecated
    {class} function getName: JString; cdecl;//Deprecated
    {class} function getTypeString: JString; cdecl;//Deprecated
    {class} function isPrimitive: Boolean; cdecl;//Deprecated
    {class} function isUnshared: Boolean; cdecl;//Deprecated
  end;

  [JavaSignature('java/io/ObjectStreamField')]
  JObjectStreamField = interface(JObject)
    ['{A48306B9-9899-47BD-BE6B-4C5922811119}']
    function getOffset: Integer; cdecl;//Deprecated
    function getType: Jlang_Class; cdecl;//Deprecated
    function getTypeCode: Char; cdecl;//Deprecated
    function toString: JString; cdecl;//Deprecated
  end;
  TJObjectStreamField = class(TJavaGenericImport<JObjectStreamFieldClass, JObjectStreamField>) end;

  JAbstractStringBuilderClass = interface(JObjectClass)
    ['{A3321EF2-EA76-44CD-90CE-DFDADB9936BD}']
    {class} function capacity: Integer; cdecl;//Deprecated
    {class} function codePointCount(start: Integer; end_: Integer): Integer; cdecl;//Deprecated
    {class} procedure ensureCapacity(min: Integer); cdecl;//Deprecated
    {class} procedure getChars(start: Integer; end_: Integer; dst: TJavaArray<Char>; dstStart: Integer); cdecl;//Deprecated
    {class} function lastIndexOf(subString: JString; start: Integer): Integer; cdecl; overload;//Deprecated
    {class} function length: Integer; cdecl;//Deprecated
    {class} function offsetByCodePoints(index: Integer; codePointOffset: Integer): Integer; cdecl;//Deprecated
    {class} function substring(start: Integer): JString; cdecl; overload;
    {class} function substring(start: Integer; end_: Integer): JString; cdecl; overload;
    {class} function toString: JString; cdecl;
  end;

  [JavaSignature('java/lang/AbstractStringBuilder')]
  JAbstractStringBuilder = interface(JObject)
    ['{39A0E6C5-8F79-44ED-BECB-02252CA2F5C0}']
    function charAt(index: Integer): Char; cdecl;//Deprecated
    function codePointAt(index: Integer): Integer; cdecl;//Deprecated
    function codePointBefore(index: Integer): Integer; cdecl;//Deprecated
    function indexOf(string_: JString): Integer; cdecl; overload;//Deprecated
    function indexOf(subString: JString; start: Integer): Integer; cdecl; overload;//Deprecated
    function lastIndexOf(string_: JString): Integer; cdecl; overload;//Deprecated
    procedure setCharAt(index: Integer; ch: Char); cdecl;
    procedure setLength(length: Integer); cdecl;
    function subSequence(start: Integer; end_: Integer): JCharSequence; cdecl;
    procedure trimToSize; cdecl;
  end;
  TJAbstractStringBuilder = class(TJavaGenericImport<JAbstractStringBuilderClass, JAbstractStringBuilder>) end;

  JStringBufferClass = interface(JAbstractStringBuilderClass)
    ['{F6BF4ECD-EA63-4AF3-A901-99D4221796D7}']
    {class} function init: JStringBuffer; cdecl; overload;//Deprecated
    {class} function init(capacity: Integer): JStringBuffer; cdecl; overload;//Deprecated
    {class} function init(string_: JString): JStringBuffer; cdecl; overload;//Deprecated
    {class} function init(cs: JCharSequence): JStringBuffer; cdecl; overload;//Deprecated
    {class} function append(b: Boolean): JStringBuffer; cdecl; overload;//Deprecated
    {class} function append(f: Single): JStringBuffer; cdecl; overload;//Deprecated
    {class} function append(i: Integer): JStringBuffer; cdecl; overload;//Deprecated
    {class} function append(l: Int64): JStringBuffer; cdecl; overload;//Deprecated
    {class} function append(chars: TJavaArray<Char>): JStringBuffer; cdecl; overload;
    {class} function append(chars: TJavaArray<Char>; start: Integer; length: Integer): JStringBuffer; cdecl; overload;
    {class} function append(s: JCharSequence): JStringBuffer; cdecl; overload;
    {class} function codePointAt(index: Integer): Integer; cdecl;
    {class} function codePointBefore(index: Integer): Integer; cdecl;
    {class} function codePointCount(beginIndex: Integer; endIndex: Integer): Integer; cdecl;
    {class} procedure getChars(start: Integer; end_: Integer; buffer: TJavaArray<Char>; idx: Integer); cdecl;
    {class} function indexOf(subString: JString; start: Integer): Integer; cdecl;
    {class} function insert(index: Integer; ch: Char): JStringBuffer; cdecl; overload;
    {class} function insert(index: Integer; d: Double): JStringBuffer; cdecl; overload;
    {class} function insert(index: Integer; f: Single): JStringBuffer; cdecl; overload;
    {class} function insert(index: Integer; obj: JObject): JStringBuffer; cdecl; overload;
    {class} function insert(index: Integer; s: JCharSequence): JStringBuffer; cdecl; overload;//Deprecated
    {class} function insert(index: Integer; s: JCharSequence; start: Integer; end_: Integer): JStringBuffer; cdecl; overload;//Deprecated
    {class} function reverse: JStringBuffer; cdecl;//Deprecated
    {class} procedure setCharAt(index: Integer; ch: Char); cdecl;//Deprecated
    {class} procedure setLength(length: Integer); cdecl;//Deprecated
    {class} function toString: JString; cdecl;
  end;

  [JavaSignature('java/lang/StringBuffer')]
  JStringBuffer = interface(JAbstractStringBuilder)
    ['{3CECFBBE-9C21-4D67-9F6F-52BB1DB2C638}']
    function append(ch: Char): JStringBuffer; cdecl; overload;//Deprecated
    function append(d: Double): JStringBuffer; cdecl; overload;//Deprecated
    function append(obj: JObject): JStringBuffer; cdecl; overload;
    function append(string_: JString): JStringBuffer; cdecl; overload;
    function append(sb: JStringBuffer): JStringBuffer; cdecl; overload;
    function append(s: JCharSequence; start: Integer; end_: Integer): JStringBuffer; cdecl; overload;
    function appendCodePoint(codePoint: Integer): JStringBuffer; cdecl;
    function charAt(index: Integer): Char; cdecl;
    function delete(start: Integer; end_: Integer): JStringBuffer; cdecl;
    function deleteCharAt(location: Integer): JStringBuffer; cdecl;
    procedure ensureCapacity(min: Integer); cdecl;
    function insert(index: Integer; b: Boolean): JStringBuffer; cdecl; overload;
    function insert(index: Integer; i: Integer): JStringBuffer; cdecl; overload;
    function insert(index: Integer; l: Int64): JStringBuffer; cdecl; overload;
    function insert(index: Integer; string_: JString): JStringBuffer; cdecl; overload;//Deprecated
    function insert(index: Integer; chars: TJavaArray<Char>): JStringBuffer; cdecl; overload;//Deprecated
    function insert(index: Integer; chars: TJavaArray<Char>; start: Integer; length: Integer): JStringBuffer; cdecl; overload;//Deprecated
    function lastIndexOf(subString: JString; start: Integer): Integer; cdecl;//Deprecated
    function offsetByCodePoints(index: Integer; codePointOffset: Integer): Integer; cdecl;//Deprecated
    function replace(start: Integer; end_: Integer; string_: JString): JStringBuffer; cdecl;//Deprecated
    function subSequence(start: Integer; end_: Integer): JCharSequence; cdecl;//Deprecated
    function substring(start: Integer): JString; cdecl; overload;//Deprecated
    function substring(start: Integer; end_: Integer): JString; cdecl; overload;//Deprecated
    procedure trimToSize; cdecl;
  end;
  TJStringBuffer = class(TJavaGenericImport<JStringBufferClass, JStringBuffer>) end;

  JStringBuilderClass = interface(JAbstractStringBuilderClass)
    ['{D9FACB66-EE60-4BCB-B5B2-248751CCF1B4}']
    {class} function init: JStringBuilder; cdecl; overload;//Deprecated
    {class} function init(capacity: Integer): JStringBuilder; cdecl; overload;//Deprecated
    {class} function init(seq: JCharSequence): JStringBuilder; cdecl; overload;//Deprecated
    {class} function init(str: JString): JStringBuilder; cdecl; overload;//Deprecated
    {class} function append(l: Int64): JStringBuilder; cdecl; overload;
    {class} function append(f: Single): JStringBuilder; cdecl; overload;
    {class} function append(d: Double): JStringBuilder; cdecl; overload;
    {class} function append(chars: TJavaArray<Char>): JStringBuilder; cdecl; overload;
    {class} function append(str: TJavaArray<Char>; offset: Integer; len: Integer): JStringBuilder; cdecl; overload;
    {class} function delete(start: Integer; end_: Integer): JStringBuilder; cdecl;
    {class} function deleteCharAt(index: Integer): JStringBuilder; cdecl;
    {class} function insert(offset: Integer; b: Boolean): JStringBuilder; cdecl; overload;
    {class} function insert(offset: Integer; f: Single): JStringBuilder; cdecl; overload;//Deprecated
    {class} function insert(offset: Integer; d: Double): JStringBuilder; cdecl; overload;//Deprecated
    {class} function insert(offset: Integer; obj: JObject): JStringBuilder; cdecl; overload;//Deprecated
    {class} function insert(offset: Integer; s: JCharSequence): JStringBuilder; cdecl; overload;//Deprecated
    {class} function insert(offset: Integer; s: JCharSequence; start: Integer; end_: Integer): JStringBuilder; cdecl; overload;//Deprecated
    {class} function replace(start: Integer; end_: Integer; string_: JString): JStringBuilder; cdecl;//Deprecated
  end;

  [JavaSignature('java/lang/StringBuilder')]
  JStringBuilder = interface(JAbstractStringBuilder)
    ['{F8A75A66-EA10-4337-9ECC-B0CA4FF4D9C5}']
    function append(b: Boolean): JStringBuilder; cdecl; overload;
    function append(c: Char): JStringBuilder; cdecl; overload;
    function append(i: Integer): JStringBuilder; cdecl; overload;
    function append(obj: JObject): JStringBuilder; cdecl; overload;
    function append(str: JString): JStringBuilder; cdecl; overload;
    function append(sb: JStringBuffer): JStringBuilder; cdecl; overload;
    function append(csq: JCharSequence): JStringBuilder; cdecl; overload;
    function append(csq: JCharSequence; start: Integer; end_: Integer): JStringBuilder; cdecl; overload;
    function appendCodePoint(codePoint: Integer): JStringBuilder; cdecl;
    function insert(offset: Integer; c: Char): JStringBuilder; cdecl; overload;//Deprecated
    function insert(offset: Integer; i: Integer): JStringBuilder; cdecl; overload;//Deprecated
    function insert(offset: Integer; l: Int64): JStringBuilder; cdecl; overload;//Deprecated
    function insert(offset: Integer; str: JString): JStringBuilder; cdecl; overload;//Deprecated
    function insert(offset: Integer; ch: TJavaArray<Char>): JStringBuilder; cdecl; overload;//Deprecated
    function insert(offset: Integer; str: TJavaArray<Char>; strOffset: Integer; strLen: Integer): JStringBuilder; cdecl; overload;//Deprecated
    function reverse: JStringBuilder; cdecl;//Deprecated
    function toString: JString; cdecl;//Deprecated
  end;
  TJStringBuilder = class(TJavaGenericImport<JStringBuilderClass, JStringBuilder>) end;

implementation

procedure RegisterTypes;
begin
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectInputStream', TypeInfo(Androidapi.JNI.Stream.JObjectInputStream));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectInputStream_GetField', TypeInfo(Androidapi.JNI.Stream.JObjectInputStream_GetField));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectInputValidation', TypeInfo(Androidapi.JNI.Stream.JObjectInputValidation));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectOutput', TypeInfo(Androidapi.JNI.Stream.JObjectOutput));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectOutputStream', TypeInfo(Androidapi.JNI.Stream.JObjectOutputStream));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectOutputStream_PutField', TypeInfo(Androidapi.JNI.Stream.JObjectOutputStream_PutField));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.Jio_ObjectStreamClass', TypeInfo(Androidapi.JNI.Stream.Jio_ObjectStreamClass));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JObjectStreamField', TypeInfo(Androidapi.JNI.Stream.JObjectStreamField));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JAbstractStringBuilder', TypeInfo(Androidapi.JNI.Stream.JAbstractStringBuilder));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JStringBuffer', TypeInfo(Androidapi.JNI.Stream.JStringBuffer));
  TRegTypes.RegisterType('Androidapi.JNI.Stream.JStringBuilder', TypeInfo(Androidapi.JNI.Stream.JStringBuilder));
end;

initialization
  RegisterTypes;
end.

